<?php

namespace App\Modules\Finance\Migrations\Notification;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Notification extends Model 
{

    protected $table = 'notifications';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function customer()
    {
        return $this->belongsTo('Customer', 'customer_id');
    }

    public function notificationName()
    {
        return $this->belongsTo('NotificationName', 'notification_name_id');
    }

    public function bank()
    {
        return $this->belongsTo('CustomerBankAccount', 'bank_id');
    }

}